/*
 * Decompiled with CFR 0.152.
 */
package io.github.lucaargolo.seasons.utils;

import io.github.lucaargolo.seasons.utils.ColorHelper;
import io.github.lucaargolo.seasons.utils.Season;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2960;
import net.minecraft.class_5321;

public class ModConfig {
    private int seasonLength = 672000;
    private SeasonLock seasonLock = new SeasonLock();
    private List<String> dimensionWhitelist = List.of("minecraft:overworld");
    private boolean doTemperatureChanges = true;
    private boolean isSeasonTiedWithSystemTime = false;
    private boolean isInNorthHemisphere = true;
    private HardcodedColors minecraftDefaultFoliage = new HardcodedColors(4764952, 5038091, 14719243, 7689492);
    private HardcodedColors minecraftSpruceFoliage = new HardcodedColors(0x619961, 0x619961, 0x619961, 0x619961);
    private HardcodedColors minecraftBirchFoliage = new HardcodedColors(8431445, 8501316, 14051328, 6705190);
    private HardcodedColors minecraftSwampGrass1 = new HardcodedColors(5011004, 5011004, 5011004, 5011004);
    private HardcodedColors minecraftSwampGrass2 = new HardcodedColors(6975545, 6975545, 6975545, 6975545);
    private boolean isDefaultHSBShiftEnabled = true;
    private DefaultHSBShift defaultHSBShift = new DefaultHSBShift();
    private final List<BiomeColors> foliageColorList = new ArrayList<BiomeColors>();
    private final List<BiomeColors> grassColorList = new ArrayList<BiomeColors>();
    private boolean isSeasonMessingCrops = true;
    private boolean isSeasonMessingBonemeal = false;
    private boolean doCropsGrowsNormallyUnderground = true;
    private DefaultCropConfig defaultCropConfig = new DefaultCropConfig(1.0f, 0.8f, 0.6f, 0.0f);
    private final List<CropConfig> cropConfigs = new ArrayList<CropConfig>();
    private boolean doAnimalsBreedInWinter = true;

    private int getShiftedColor(Season season, int defaultColor) {
        Color initialColor = new Color(defaultColor);
        HSBShift hueShift = this.defaultHSBShift.getHSBShift(season);
        Color finalColor = ColorHelper.changeHueSatBri(initialColor, hueShift.hue, hueShift.saturation, hueShift.brightness);
        return finalColor.getRGB();
    }

    public Optional<Integer> getSeasonFoliageColor(class_1959 biome, class_2960 biomeIdentifier, Season season) {
        Optional defaultColor;
        Optional<BiomeColors> colors = this.foliageColorList.stream().filter(it -> it.biomeIdentifier.equals(biomeIdentifier.toString())).findFirst();
        Optional<Integer> color = colors.map(biomeColors -> biomeColors.colors.getColor(season));
        if (color.isEmpty() && this.isDefaultHSBShiftEnabled && (defaultColor = biome.method_24377().method_30811()).isPresent()) {
            return Optional.of(this.getShiftedColor(season, (Integer)defaultColor.get()));
        }
        return color;
    }

    public Optional<Integer> getSeasonGrassColor(class_1959 biome, class_2960 biomeIdentifier, Season season) {
        Optional defaultColor;
        Optional<BiomeColors> colors = this.grassColorList.stream().filter(it -> it.biomeIdentifier.equals(biomeIdentifier.toString())).findFirst();
        Optional<Integer> color = colors.map(biomeColors -> biomeColors.colors.getColor(season));
        if (color.isEmpty() && this.isDefaultHSBShiftEnabled && (defaultColor = biome.method_24377().method_30812()).isPresent()) {
            return Optional.of(this.getShiftedColor(season, (Integer)defaultColor.get()));
        }
        return color;
    }

    public float getSeasonCropMultiplier(class_2960 cropIdentifier, Season season) {
        Optional<CropConfig> config = this.cropConfigs.stream().filter(it -> it.cropIdentifier.equals(cropIdentifier.toString())).findFirst();
        return config.map(cropConfig -> Float.valueOf(cropConfig.getModifier(season))).orElse(Float.valueOf(this.defaultCropConfig.getModifier(season))).floatValue();
    }

    public boolean doAnimalsBreedInWinter() {
        return this.doAnimalsBreedInWinter;
    }

    public boolean isSeasonMessingCrops() {
        return this.isSeasonMessingCrops;
    }

    public boolean isSeasonMessingBonemeal() {
        return this.isSeasonMessingBonemeal;
    }

    public boolean doCropsGrowsNormallyUnderground() {
        return this.doCropsGrowsNormallyUnderground;
    }

    public HardcodedColors getMinecraftDefaultFoliage() {
        return this.minecraftDefaultFoliage;
    }

    public HardcodedColors getMinecraftSpruceFoliage() {
        return this.minecraftSpruceFoliage;
    }

    public HardcodedColors getMinecraftBirchFoliage() {
        return this.minecraftBirchFoliage;
    }

    public HardcodedColors getMinecraftSwampGrass1() {
        return this.minecraftSwampGrass1;
    }

    public HardcodedColors getMinecraftSwampGrass2() {
        return this.minecraftSwampGrass2;
    }

    public boolean doTemperatureChanges() {
        return this.doTemperatureChanges;
    }

    public int getSeasonLength() {
        return this.seasonLength;
    }

    public boolean isSeasonLocked() {
        return this.seasonLock.isSeasonLocked;
    }

    public Season getLockedSeason() {
        return this.seasonLock.lockedSeason;
    }

    public boolean isValidInDimension(class_5321<class_1937> dimension) {
        return this.dimensionWhitelist.contains(dimension.method_29177().toString());
    }

    public boolean isSeasonTiedWithSystemTime() {
        return this.isSeasonTiedWithSystemTime;
    }

    public boolean isInNorthHemisphere() {
        return this.isInNorthHemisphere;
    }

    private static class SeasonLock {
        private boolean isSeasonLocked = false;
        private Season lockedSeason = Season.SPRING;

        private SeasonLock() {
        }
    }

    public static class HardcodedColors {
        private int springColor;
        private int summerColor;
        private int fallColor;
        private int winterColor;

        HardcodedColors(int springColor, int summerColor, int fallColor, int winterColor) {
            this.springColor = springColor;
            this.summerColor = summerColor;
            this.fallColor = fallColor;
            this.winterColor = winterColor;
        }

        public int getColor(Season season) {
            return switch (season) {
                default -> throw new IncompatibleClassChangeError();
                case Season.SPRING -> this.springColor;
                case Season.SUMMER -> this.summerColor;
                case Season.FALL -> this.fallColor;
                case Season.WINTER -> this.winterColor;
            };
        }
    }

    private static class DefaultHSBShift {
        private HSBShift springHSBShift = new HSBShift(0.0f, 100.0f, 0.0f);
        private HSBShift summerHSBShift = new HSBShift(0.0f, 150.0f, -10.0f);
        private HSBShift fallHSBShift = new HSBShift(-65.0f, 125.0f, -15.0f);
        private HSBShift winterHSBShift = new HSBShift(-65.0f, 80.0f, -40.0f);

        private DefaultHSBShift() {
        }

        public HSBShift getHSBShift(Season season) {
            return switch (season) {
                default -> throw new IncompatibleClassChangeError();
                case Season.SPRING -> this.springHSBShift;
                case Season.SUMMER -> this.summerHSBShift;
                case Season.FALL -> this.fallHSBShift;
                case Season.WINTER -> this.winterHSBShift;
            };
        }
    }

    private static class DefaultCropConfig {
        private float springModifier;
        private float summerModifier;
        private float fallModifier;
        private float winterModifier;

        public DefaultCropConfig(float springModifier, float summerModifier, float fallModifier, float winterModifier) {
            this.springModifier = springModifier;
            this.summerModifier = summerModifier;
            this.fallModifier = fallModifier;
            this.winterModifier = winterModifier;
        }

        public float getModifier(Season season) {
            return switch (season) {
                default -> throw new IncompatibleClassChangeError();
                case Season.SPRING -> this.springModifier;
                case Season.SUMMER -> this.summerModifier;
                case Season.FALL -> this.fallModifier;
                case Season.WINTER -> this.winterModifier;
            };
        }
    }

    private static class HSBShift {
        private float hue;
        private float saturation;
        private float brightness;

        public HSBShift(float hue, float saturation, float brightness) {
            this.hue = hue;
            this.saturation = saturation;
            this.brightness = brightness;
        }
    }

    private static class CropConfig {
        private String cropIdentifier;
        private float springModifier;
        private float summerModifier;
        private float fallModifier;
        private float winterModifier;

        public CropConfig() {
            this.cropIdentifier = "";
            this.springModifier = 1.0f;
            this.summerModifier = 0.8f;
            this.fallModifier = 0.6f;
            this.winterModifier = 0.0f;
        }

        public CropConfig(String cropIdentifier, float springModifier, float summerModifier, float fallModifier, float winterModifier) {
            this.cropIdentifier = cropIdentifier;
            this.springModifier = springModifier;
            this.summerModifier = summerModifier;
            this.fallModifier = fallModifier;
            this.winterModifier = winterModifier;
        }

        public float getModifier(Season season) {
            return switch (season) {
                default -> throw new IncompatibleClassChangeError();
                case Season.SPRING -> this.springModifier;
                case Season.SUMMER -> this.summerModifier;
                case Season.FALL -> this.fallModifier;
                case Season.WINTER -> this.winterModifier;
            };
        }
    }

    private static class BiomeColors {
        private String biomeIdentifier;
        private HardcodedColors colors;

        BiomeColors() {
            this.biomeIdentifier = "";
            this.colors = new HardcodedColors(0, 0, 0, 0);
        }

        BiomeColors(String biomeIdentifier, int springColor, int summerColor, int fallColor, int winterColor) {
            this.biomeIdentifier = biomeIdentifier;
            this.colors = new HardcodedColors(springColor, summerColor, fallColor, winterColor);
        }
    }
}

